/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  complementary pwm.c
*  :  LuF
*  :  V1.10
*  :  2017/10/20
*  :  T11PWM
          1.ʹоƬT11PWMģʽPB0PB1˿ʵΪ100usʱΪ2usռձΪ80%~20%ĴεݼԴηķ
          2.оƬʹ16MHzϵͳʱӣӦT11ʱʱԴΪ1/16MHzT11ԤƵ1:1T11ڼĴT11Pʼֵļ㹫ʽӦΪ
            PWM100us =T11P(1/16MHz)1ԤƵȣõT11PֵPERIOD= 1600(0x0640)
            PMM80us = T11R0(1/16MHz)1ԤƵȣõT11R0ֵDUTY =1280(0x0500)
            PWMռձ 50% = T11R0 / T11P
            PWMʱ2us = T11R1(1/16MHz)
*  ע:  ES7P295x
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

void RAMClear(void);

#define PERIOD 1600   //0x640100us
#define DUTY 1280     //0x0500~0x014080-20us
#define DTIME 32      //0x202us
unsigned int N_Duty;
unsigned char N_Change;

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void isr(void) interrupt
{
    if(T11PIE &&T11PIF) 
    {                                //T11ж
        T11PIF = 0;
        if(N_Duty >= 1280)
        {   
            N_Change = 1;
        }
        if(N_Duty <= 320)
        {
            N_Change = 0;
        }

        if(N_Change)
        {
            N_Duty -= 240; 
            
            T11R0H = N_Duty>> 8;
            T11R0L = N_Duty;          //PWM 
        }
        else
        {
            N_Duty += 240; 
            T11R0H = N_Duty>> 8;
            T11R0L = N_Duty;          //PWM
        }
    }
}

/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main()
{
    RAMClear();                 //RAM
    
    PBS = 0x00;                 //PBΪI/O
    PB0 = 0;                    //PB0˿͵ƽ
    PBT0= 0; 		            //PB0˿Ϊ      
    PB1 = 0;                    //PB1˿͵ƽ
    PBT1= 0; 		            //PB1˿Ϊ

    N_Duty = DUTY;
    T11CL = 0xD3;		        //T11ڻPWMģʽ

    T11CM = 0x00;		        //T11ԤƵƵ
    P11EN = 1;		            //PWM111PB1
    P10EN = 1;                  //PWM110PB0
    
    T11PH = PERIOD >> 8;         
    T11PL = PERIOD;             //
    T11R1H = DTIME >> 8;
    T11R1L = DTIME;             //ʱ
    T11R0H = N_Duty >> 8;
    T11R0L = N_Duty;            //þ
    
    T11CH = 0x80;		        //ʹT11
    T11PIE = 1; 		        //ʹT11ж
    GIE = 1;		            //ʹȫж 
    while(1);
}

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
	__asm{				    //ַ0x0000~0x05FF
		MOVI 0x00			
		MOVA IAAH 
		MOVI 0x00			
		MOVA IAAL 
		CLR	 IAD 
		INC	 IAAL,1
		JBS	 PSW,C
		GOTO $-3
		INC IAAH,1
		MOVI 0x06
		SUB  IAAH,0
		JBS	 PSW,C	
		GOTO $-8
	}
}
